const API_KEY = 'YOUR_GOOGLE_TRANSLATE_API_KEY'; // Substitua pela sua chave da API do Google Translate

// Dicionário de traduções
const translations = {
    "Preconfigured": "",
    "Preconfig": "",
    "Processor": "Processador",
    "RAM": "Memória RAM",
    "Storage": "Armazenamento",
    "Included": "Incluído",
    "Intel Core Series": "Série Intel Core",
    "AMD": "AMD",
    // Adicione mais traduções conforme necessário
};

// Função para realizar substituições de palavras indesejadas
function sanitizeText(text) {
    if (typeof text === 'string') {
        return text
            .replace(/Preconfigured/g, '')
            .replace(/Preconfig/g, '');
    }
    return text;
}

// Função para traduzir texto usando o dicionário
function translateText(text) {
    if (typeof text === 'string') {
        // Substituir palavras e frases usando o dicionário
        return text.split(' ').map(word => translations[word] || word).join(' ');
    }
    return text;
}

// Função para substituir "instant" por "5 horas"
function replaceInstant(text) {
    if (typeof text === 'string') {
        return text.replace(/instant/g, '5 horas');
    }
    return text;
}

// Função para obter os dados do PHP e popular a tabela
function loadProducts() {
    fetch('api_request.php') // Substitua pelo caminho correto do seu script PHP
        .then(response => response.json())
        .then(data => {
            if (data.products) {
                const tbody = document.getElementById('products-table-body');
                data.products.forEach(product => {
                    // Acessa o objeto ordering e cria uma string formatada
                    const orderingObject = product.ordering || {};
                    
                    // Sanitiza e formata o campo ordering
                    const orderingString = Object.entries(orderingObject)
                        .filter(([key]) => ['processor', 'ram', 'storage', 'included'].includes(key)) // Filtra apenas os sub-campos desejados
                        .map(([key, value]) => `<div class="sub-field"><strong>${translateText(key.charAt(0).toUpperCase() + key.slice(1))}:</strong> ${sanitizeText(value) || 'N/A'}</div>`)
                        .join(''); // Cria uma string HTML para a célula

                    // Sanitiza o nome do produto e traduz
                    const sanitizedProductName = sanitizeText(product.name);
                    const translatedName = translateText(sanitizedProductName); // Traduza o nome do produto

                    // Substitui "instant" por "5 horas"
                    const deploymentType = replaceInstant(product.deployment_type);

                    // Converte o preço para número, multiplica por 11 e formata para exibição
                    const price = parseFloat(product.price.replace('R$', '').replace(',', '.')); // Remove 'R$' e substitui vírgula por ponto
                    const priceMultiplied = (price * 11).toFixed(2); // Multiplica por 11 e fixa duas casas decimais
                    const formattedPrice = `R$ ${priceMultiplied.replace('.', ',')}`; // Formata o preço para o formato brasileiro

                    const row = document.createElement('tr');

                    row.innerHTML = `
                        <td>${product.id}</td> <!-- Adiciona o ID do produto -->
                        <td>${translatedName}</td> <!-- Adiciona o nome do produto traduzido -->
                        <td><div class="json-viewer">${orderingString}</div></td> <!-- Exibindo o valor formatado de ordering -->
                        <td>${formattedPrice}</td> <!-- Preço multiplicado por 11 -->
                        <td>${product.qty}</td>
                        <td>${deploymentType}</td> <!-- Tipo de Implantação ajustado -->
                        <td>
                            <select>
                                ${product.initial_os_list.map(os => `<option value="${os}">${os}</option>`).join('')}
                            </select>
                        </td>
                    `;

                    tbody.appendChild(row);
                });
            } else {
                console.error('Nenhum produto encontrado');
            }
        })
        .catch(error => console.error('Erro ao carregar os produtos:', error));
}

// Chama a função quando a página é carregada
window.onload = loadProducts;
