<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Servidores em Estoque</title>
    <style>
        body {
            font-family: Arial, sans-serif; /* Fonte limpa e moderna */
            background-color: #f0f4f8; /* Cor de fundo clara e suave */
            margin: 0;
            padding: 20px;
        }

        h1 {
            font-size: 24px;
            color: #333;
            text-align: center;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }

        th {
            background-color: #f4f4f4;
            color: #333;
            font-weight: bold;
        }

        tr:hover {
            background-color: #f9f9f9;
        }

        select {
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            background-color: #ffffff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            outline: none;
        }

        select:focus {
            border-color: #007bff; /* Cor do foco */
            box-shadow: 0 0 0 2px rgba(38, 143, 255, 0.2); /* Efeito de foco */
        }

        .json-viewer {
            white-space: pre-wrap;
            font-family: 'Courier New', Courier, monospace;
            background-color: #ffffff;
            padding: 15px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            max-width: 100%;
            overflow-x: auto; /* Adiciona rolagem horizontal, se necessário */
        }

        .sub-field {
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    <h1>Servidores em Estoque</h1>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Ordenação</th>
                <th>Preço</th>
                <th>Quantidade</th>
                <th>Tipo de Implantação</th>
                <th>Opções de Sistema Operacional</th>
            </tr>
        </thead>
        <tbody id="products-table-body">
            <!-- Linhas da tabela serão inseridas aqui via JavaScript -->
        </tbody>
    </table>
    <script src="script.js"></script>
</body>
</html>
