<?php
header('Content-Type: application/json');

// Configurações da API
$api_url = 'https://my.nocix.net/api/in-stock-servers/';
$user = '49912_nottorium';
$auth_token = 'fm5qgx4yd09mxpgrye8zit6uoxe45y89';

// Função para manipulação de erros
function handle_error($message, $http_code = 500) {
    http_response_code($http_code);
    echo json_encode(['error' => $message]);
    exit;
}

// Autenticação em Base64
$auth_base64 = base64_encode("$user:$auth_token");

// Inicialize cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Basic ' . $auth_base64,
    'Content-Type: application/json'
]);

// Execução da requisição
$response = curl_exec($ch);

if (curl_errno($ch)) {
    handle_error('Erro de cURL: ' . curl_error($ch));
}

$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
if ($http_code !== 200) {
    handle_error('Código de status HTTP: ' . $http_code, $http_code);
}

curl_close($ch);

// Decodificação do JSON
$data = json_decode($response, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    handle_error('Erro ao decodificar JSON: ' . json_last_error_msg());
}

// Verificação da estrutura de dados
if (!is_array($data) || empty($data)) {
    handle_error('Formato de dados inesperado ou vazio');
}

// Filtragem e formatação dos dados
$products = array_filter(array_map(function ($server) {
    // Verificar se todas as chaves necessárias existem
    if (!isset($server['id'], $server['name'], $server['price'], $server['qty'], 
               $server['deployment_type'], $server['metadata']['initial_os_list'], 
               $server['metadata']['ordering'])) {
        return null;
    }

    // Retornar apenas os campos solicitados
    return [
        'id' => $server['id'],
        'name' => $server['name'],
        'price' => $server['price'],
        'qty' => $server['qty'],
        'deployment_type' => $server['deployment_type'],
        'ordering' => $server['metadata']['ordering'],
        'initial_os_list' => $server['metadata']['initial_os_list'],
    ];
}, $data));

// Remover itens nulos
$products = array_values(array_filter($products));

if (empty($products)) {
    handle_error('Nenhum produto válido encontrado');
}

// Estrutura da saída JSON
echo json_encode(['products' => $products], JSON_PRETTY_PRINT);
?>
