document.addEventListener('DOMContentLoaded', fetchEstoque);

async function fetchEstoque() {
    try {
        // Solicitação para o backend PHP
        const response = await fetch('https://vitthost.com.br/estoque/estoque.php');

        if (!response.ok) {
            throw new Error(`Erro na solicitação: ${response.status} ${response.statusText}`);
        }

        // Converte a resposta para JSON
        const data = await response.json();
        
        // Inicializa um objeto para mapear ids de produtos para suas quantidades
        const estoqueMap = {};

        // Preenche o mapa com as quantidades
        data.forEach(item => {
            estoqueMap[item.name] = item.qty;
        });

        // Atualiza os elementos na página com as quantidades
        document.getElementById('vps-ca-01').textContent = estoqueMap['VPS-CA-01'] || '0';
        document.getElementById('vps-ca-02').textContent = estoqueMap['VPS-CA-02'] || '0';
        document.getElementById('vps-ca-03').textContent = estoqueMap['VPS-CA-03'] || '0';
        document.getElementById('vps-ca-04').textContent = estoqueMap['VPS-CA-04'] || '0';
        document.getElementById('vps-ca-05').textContent = estoqueMap['VPS-CA-05'] || '0';
        document.getElementById('vps-ca-06').textContent = estoqueMap['VPS-CA-06'] || '0';
        document.getElementById('mc').textContent = estoqueMap['mc'] || '0';

    } catch (error) {
        // Exibe uma mensagem de erro na página
        document.querySelectorAll('.product-field span').forEach(span => {
            span.textContent = `Erro: ${error.message}`;
        });
        console.error(error);
    }
}
