document.addEventListener('DOMContentLoaded', () => {
    // Inicializa a consulta de estoque
    fetchEstoque();

    // Define um intervalo para atualizar a cada 10 minutos
    setInterval(fetchEstoque, 10 * 60 * 1000); // 10 minutos em milissegundos
});

async function fetchEstoque() {
    try {
        // Solicitação para o backend PHP
        const response = await fetch('estoque.php');

        if (!response.ok) {
            throw new Error(`Erro na solicitação: ${response.status} ${response.statusText}`);
        }

        // Converte a resposta para JSON
        const data = await response.json();

        // Cria um mapa para armazenar as quantidades de produtos
        const estoqueMap = {};

        // Preenche o mapa com as quantidades
        data.forEach(item => {
            estoqueMap[item.name] = item.qty;
        });

        // Atualiza cada seção com a quantidade do produto
        document.querySelectorAll('.product-section').forEach(section => {
            const productName = section.querySelector('.product-name').textContent.trim();
            const quantityElement = section.querySelector('.product-quantity');
            
            if (quantityElement) {
                quantityElement.textContent = estoqueMap[productName] || '0';

                // Estilo para a quantidade
                quantityElement.style.fontSize = '1em'; // Tamanho da fonte para a quantidade
                quantityElement.style.color = '#333'; // Cor da fonte para a quantidade
            }
        });

        // Adiciona estilos aos nomes dos produtos e às seções
        document.querySelectorAll('.product-section').forEach(section => {
            const productNameElement = section.querySelector('.product-name');
            
            if (productNameElement) {
                // Estilo para o nome do produto
                productNameElement.style.fontSize = '1.5em'; // Tamanho maior para o nome do produto
                productNameElement.style.fontWeight = 'bold'; // Negrito para o nome do produto
            }

            // Estilo para a seção do produto
            section.style.marginBottom = '20px';
            section.style.padding = '10px';
            section.style.border = '1px solid #ddd'; // Borda leve para separar as seções
            section.style.borderRadius = '5px'; // Borda arredondada
            section.style.backgroundColor = '#f9f9f9'; // Fundo claro para melhor contraste
        });

    } catch (error) {
        // Exibe uma mensagem de erro na página
        document.querySelectorAll('.product-quantity').forEach(element => {
            element.textContent = `Erro: ${error.message}`;
            element.style.fontSize = '1em'; // Tamanho da fonte para erros
            element.style.color = 'red'; // Cor da fonte para erros
        });
        console.error(error);
    }
}
